
IF (EXISTS(SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(N'[dbo].[ds_Build_HolidayDates]') AND [type]='P'))
DROP PROCEDURE [dbo].[ds_Build_HolidayDates]
GO

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[ds_Build_HolidayDates]
  @inYear  int

AS
BEGIN
  /*
    
    Remove all created dates for the supplied year from HolidayDates table.
    
  */
  DELETE FROM HolidayDates
  WHERE
    Year = @inYear
  
  /*
    
    Loop through all active (ReportFlag = 1) records in the Holidays table and find their active days for the year.
    
  */
  INSERT INTO HolidayDates
    SELECT
      s1.HolidayID,
      @inYear,
      s1.DayStart,
      DATEADD(dd, s1.DaysAfter, s1.DayStart) AS DayEnd
    FROM
    (
      SELECT
        HolidayID,
        DaysAfter,
        dbo.fn_FindDate
        (
          HolidayID,
          Title,
          ReportFlag,
          DayOffFlag,
          StartYear,
          EndYear,
          DaysPrior,
          DaysAfter,
          MonthOf,
          DayOf,
          NameDay,
          WeekNumber,
          LastDayFlag,
          FullWeekFlag,
          BaseHoliday,
          DaysVariance,
          SpecialCalc,
          @inYear,
          SlideDate
        ) AS DayStart
      FROM Holidays
      WHERE
        StartYear <= @inYear
        AND (EndYear = 0 OR EndYear >= @inYear)
        AND (ReportFlag = 1)
    ) AS s1
  
END
GO

